<?php
// الاتصال بقاعدة البيانات
$pdo = new PDO("mysql:host=localhost;dbname=attorneytypes;charset=utf8", "root", "");

// نجلب كل البيانات من جدول caeg
$stmt = $pdo->query("SELECT Id, Name, ParentId FROM caeg ORDER BY Id");
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

// نبني الشجرة
$tree = [];
$lookup = [];

// أولاً: نجهز lookup لكل العناصر
foreach ($rows as $row) {
    $row['children'] = [];
    $lookup[$row['Id']] = $row;
}

// ثانياً: نربط كل عنصر بأبوه أو نضعه كجذر
foreach ($lookup as $id => &$node) {
    if ($node['ParentId'] == null) {
        $tree[$id] = &$node;
    } else {
        $lookup[$node['ParentId']]['children'][$id] = &$node;
    }
}

// دالة recursive لعرض HTML
function renderTree($nodes) {
    echo "<ul>";
    foreach ($nodes as $node) {
        echo "<li><span class='node'>" . htmlspecialchars($node['Name']) . "</span>";
        if (!empty($node['children'])) {
            renderTree($node['children']);
        }
        echo "</li>";
    }
    echo "</ul>";
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>شجرة التصنيفات</title>
<style>
ul { list-style-type: none; margin-left: 20px; }
.node { cursor: pointer; color: #0056b3; font-weight: bold; }
.hidden { display: none; }
</style>
</head>
<body>
<h2>شجرة التصنيفات</h2>

<?php renderTree($tree); ?>

<script>
// جعل الشجرة قابلة للفتح/الطي
document.querySelectorAll(".node").forEach(function(el) {
    el.addEventListener("click", function() {
        let nextUl = this.parentElement.querySelector("ul");
        if (nextUl) {
            nextUl.classList.toggle("hidden");
        }
    });
});
</script>
</body>
</html>
